/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Legende;
import cds.aladin.Plan;
import cds.aladin.PlanTool;
import cds.aladin.SourceTag;
import cds.aladin.ViewSimple;

public class SourcePhot
extends SourceTag {
    private static final String FILTERNAME = "obj_elong";
    private static final String FILTER = "#Object elongation\nfilter obj_elong { draw ellipse(${FWHM_X}/2,${FWHM_Y}/2,270-${Angle}) }";
    protected static Legende legende = SourcePhot.createLegende();
    private double[] iqe = null;

    protected static Legende createLegende() {
        if (legende != null) {
            return legende;
        }
        legende = Legende.adjustDefaultLegende(legende, 3, new String[]{"_RAJ2000", "_DEJ2000", "ID", "Image", "RA (ICRS)", "DE (ICRS)", "X", "Y", "FWHM_X", "FWHM_Y", "Angle", "Peak", "Background"});
        legende = Legende.adjustDefaultLegende(legende, 6, new String[]{"double", "double", "char", "char", "char", "char", "double", "double", "double", "double", "double", "double", "double"});
        legende = Legende.adjustDefaultLegende(legende, 5, new String[]{"deg", "deg", "", "", "", "", "deg", "", "", "", "", "", ""});
        legende = Legende.adjustDefaultLegende(legende, 10, new String[]{"10", "10", "15", "10", "13", "13", "8", "8", "10", "10", "5", "10", "10"});
        legende = Legende.adjustDefaultLegende(legende, 12, new String[]{"6", "6", "", "", "2", "3", "2", "2", "2", "2", "0", "3", "3"});
        legende = Legende.adjustDefaultLegende(legende, 4, new String[]{"RA", "DEC", "Identifier", "Reference image", "Right ascension", "Declination", "X image coordinate", "Y image coordinate", "X Full Width at Half Maximum", "Y Full Width at Half Maximum", "Angle", "Source peak", "image background"});
        legende = Legende.adjustDefaultLegende(legende, 7, new String[]{"pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "meta.id;meta.main", "", "pos.eq.ra", "pos.eq.dec", "pos.cartesian.x;obs.field", "pos.cartesian.y;obs.field", "", "", "pos.posAng;obs.field", "", "instr.background;obs.field"});
        SourcePhot.legende.name = "Pixel statistics";
        SourcePhot.hideRADECLegende(legende);
        return legende;
    }

    protected SourcePhot(Plan plan, ViewSimple v, Coord c, double[] iqe) {
        super(plan, v, c, null);
        this.iqe = iqe;
        this.resumeMesures();
        if (((PlanTool)plan).findFilter(FILTERNAME) < 0) {
            ((PlanTool)plan).addFilter(FILTER);
        }
        ((PlanTool)plan).setFilter(-1);
    }

    @Override
    protected void suite() {
        this.setLeg(legende);
        this.setId();
        this.setShape(15);
    }

    @Override
    protected void resumeMesures() {
        Coord c = new Coord(this.raj, this.dej);
        this.info = "<&_A|Phots>\t" + this.raj + "\t" + this.dej + "\t" + this.id + "\t" + this.planBase.label + "\t\t" + c.getRA() + "\t" + c.getDE() + "\t" + this.iqe[0] + "\t" + this.iqe[2] + "\t" + this.iqe[1] + "\t" + this.iqe[3] + "\t" + this.iqe[4] + "\t" + this.iqe[5] + "\t" + this.iqe[6];
    }

    @Override
    public String getObjType() {
        return "Phot";
    }

    @Override
    protected int getL() {
        return super.getL() * 3;
    }
}

